/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blockentity;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.pizzacraft.blockentity.BaseBlockEntity;
import com.tiviacz.pizzacraft.blockentity.PizzaHungerSystem;
import com.tiviacz.pizzacraft.blocks.OvenBlock;
import com.tiviacz.pizzacraft.blocks.PizzaBlock;
import com.tiviacz.pizzacraft.blocks.RawPizzaBlock;
import com.tiviacz.pizzacraft.client.PizzaBakedModel;
import com.tiviacz.pizzacraft.container.PizzaMenu;
import com.tiviacz.pizzacraft.init.ModBlockEntityTypes;
import com.tiviacz.pizzacraft.init.ModBlocks;
import com.tiviacz.pizzacraft.init.ModItems;
import com.tiviacz.pizzacraft.init.PizzaLayers;
import com.tiviacz.pizzacraft.util.FoodUtils;
import com.tiviacz.pizzacraft.util.NBTUtils;
import com.tiviacz.pizzacraft.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class PizzaBlockEntity
extends BaseBlockEntity
implements MenuProvider {
    private final ItemStackHandler inventory = this.createHandler();
    private int leftBakingTime = -1;
    private int leftFreshTime = -1;
    private final int baseBakingTime = 600;
    private final int baseFreshTime = 1800;
    private int selectedSlot = 0;
    private Pair<Integer, Float> refillment = Pair.of((Object)0, (Object)Float.valueOf(0.0f));
    private List<Pair<MobEffectInstance, Float>> effects = new ArrayList<Pair<MobEffectInstance, Float>>();
    private final LazyOptional<ItemStackHandler> inventoryCapability = LazyOptional.of(() -> this.inventory);
    private final String LEFT_BAKING_TIME = "LeftBakingTime";
    private final String LEFT_FRESH_TIME = "LeftFreshTime";
    private final String HUNGER = "Hunger";
    private final String SATURATION = "Saturation";
    private final String EFFECTS = "Effects";
    public static Set<Item> baseIngredients = new HashSet<Item>(Collections.singletonList((Item)ModItems.CHEESE.get()));

    public PizzaBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.PIZZA.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.leftBakingTime = compound.m_128451_("LeftBakingTime");
        this.leftFreshTime = compound.m_128451_("LeftFreshTime");
        this.refillment = Pair.of((Object)compound.m_128451_("Hunger"), (Object)Float.valueOf(compound.m_128457_("Saturation")));
        this.effects = NBTUtils.readEffectsFromTag(compound);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("LeftBakingTime", this.leftBakingTime);
        compound.m_128405_("LeftFreshTime", this.leftFreshTime);
        compound.m_128405_("Hunger", ((Integer)this.refillment.getFirst()).intValue());
        compound.m_128350_("Saturation", ((Float)this.refillment.getSecond()).floatValue());
        compound.m_128365_("Effects", (Tag)NBTUtils.writeEffectsToTag(this.effects));
    }

    public InteractionResult onBlockActivated(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            ItemStack stack = player.m_21120_(hand);
            if (this.isRaw() && !this.isBaking()) {
                if (stack.m_41619_()) {
                    if (player.m_6047_()) {
                        this.openGUI(player, this, this.m_58899_());
                        return InteractionResult.SUCCESS;
                    }
                    for (int i = this.inventory.getSlots() - 1; i >= 0; --i) {
                        ItemStack firstNotEmpty = this.inventory.getStackInSlot(i);
                        if (firstNotEmpty.m_41619_()) continue;
                        this.selectedSlot = i;
                        break;
                    }
                    if (!this.inventory.getStackInSlot(this.selectedSlot).m_41619_()) {
                        ItemStack modifiedCopy = this.inventory.getStackInSlot(this.selectedSlot).m_41777_();
                        modifiedCopy.m_41764_(1);
                        if (!player.m_150109_().m_36054_(modifiedCopy)) {
                            this.f_58857_.m_7967_((Entity)new ItemEntity(player.f_19853_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), modifiedCopy));
                        }
                        this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.7f, 0.8f + this.f_58857_.f_46441_.m_188501_());
                        this.decreaseInSlot(this.selectedSlot, 1);
                        this.m_6596_();
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    for (int i = 0; i < this.inventory.getSlots(); ++i) {
                        ItemStack firstEmpty = this.inventory.getStackInSlot(i);
                        if (!Utils.checkItemStacksAndCount(firstEmpty, new ItemStack((ItemLike)stack.m_41720_(), 1), PizzaLayers.getMaxStackSizeForStack(firstEmpty)) && !firstEmpty.m_41619_()) continue;
                        this.selectedSlot = i;
                        break;
                    }
                    if (this.selectedSlot < 9 && this.canAddIngredient(stack, this.selectedSlot)) {
                        if (!this.inventory.getStackInSlot(this.selectedSlot).m_41619_()) {
                            ItemStack modifiedCopy = this.inventory.getStackInSlot(this.selectedSlot).m_41777_();
                            modifiedCopy.m_41764_(modifiedCopy.m_41613_() + 1);
                            this.inventory.setStackInSlot(this.selectedSlot, modifiedCopy);
                        } else {
                            ItemStack modifiedCopy = stack.m_41777_();
                            modifiedCopy.m_41764_(1);
                            this.inventory.setStackInSlot(this.selectedSlot, modifiedCopy);
                        }
                        stack.m_41774_(1);
                        this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.7f, 0.8f + this.f_58857_.f_46441_.m_188501_());
                        this.m_6596_();
                        return InteractionResult.SUCCESS;
                    }
                }
            }
            if (!this.isRaw() && stack.m_41619_() && player.m_6047_()) {
                this.openGUI(player, this, this.m_58899_());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public void writeToSliceItemStack(ItemStack stack, int sliceNumber) {
        CompoundTag compound = new CompoundTag();
        if (this.isEmpty((IItemHandlerModifiable)this.inventory)) {
            return;
        }
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        if (FoodUtils.requiresAddition((Integer)this.refillment.getFirst(), sliceNumber)) {
            compound.m_128379_("RequiresAddition", true);
        }
        stack.m_41751_(compound);
    }

    public void writeToItemStack(ItemStack stack) {
        CompoundTag compound = new CompoundTag();
        if (this.isEmpty((IItemHandlerModifiable)this.inventory)) {
            return;
        }
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("LeftFreshTime", this.leftFreshTime);
        stack.m_41751_(compound);
    }

    public void readFromStack(ItemStack stack) {
        if (stack.m_41783_() != null) {
            this.inventory.deserializeNBT(stack.m_41783_().m_128469_("Inventory"));
            this.leftFreshTime = stack.m_41783_().m_128451_("LeftFreshTime");
            this.setHungerAndSaturationRefillment();
        }
    }

    public boolean isFresh() {
        return this.leftFreshTime > 0;
    }

    public int getLeftFreshTime() {
        return this.leftFreshTime;
    }

    public int getDefaultFreshTime() {
        return this.baseFreshTime;
    }

    public boolean isBaking() {
        return this.leftBakingTime > 0;
    }

    public int getLeftBakingTime() {
        return this.leftBakingTime;
    }

    public int getDefaultBakingTime() {
        return this.baseBakingTime;
    }

    public boolean isRaw() {
        if (this.f_58857_ == null) {
            return true;
        }
        return this.f_58857_.m_8055_(this.m_58899_()).m_60734_() instanceof RawPizzaBlock;
    }

    public int getBakingTime() {
        int bakingTime = this.getDefaultBakingTime();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            bakingTime += 20 * this.inventory.getStackInSlot(i).m_41613_();
        }
        return bakingTime;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PizzaBlockEntity blockEntity) {
        if (!blockEntity.isRaw() && blockEntity.isFresh()) {
            --blockEntity.leftFreshTime;
            if (blockEntity.leftFreshTime == 0) {
                blockEntity.leftFreshTime = -1;
            }
        }
        if (blockEntity.isRaw()) {
            if (blockEntity.isBaking()) {
                --blockEntity.leftBakingTime;
                if (blockEntity.leftBakingTime == 0 || !(level.m_8055_(blockEntity.m_58899_().m_7495_()).m_60734_() instanceof OvenBlock)) {
                    if (blockEntity.leftBakingTime == 0) {
                        if (!level.f_46443_) {
                            level.m_46597_(blockEntity.m_58899_(), ((Block)ModBlocks.PIZZA.get()).m_49966_());
                        }
                        blockEntity.leftFreshTime = blockEntity.baseFreshTime;
                    }
                    blockEntity.leftBakingTime = -1;
                }
            } else if (!blockEntity.isBaking() && level.m_8055_(blockEntity.m_58899_().m_7495_()).m_60734_() instanceof OvenBlock) {
                blockEntity.leftBakingTime = blockEntity.getBakingTime();
            }
        }
    }

    public void setHungerAndSaturationRefillment() {
        PizzaHungerSystem instance = new PizzaHungerSystem(this.inventory);
        this.refillment = Pair.of((Object)instance.getHunger(), (Object)Float.valueOf(instance.getSaturation()));
        this.effects = instance.getEffects();
    }

    public List<Pair<MobEffectInstance, Float>> getEffects() {
        return this.effects;
    }

    public Pair<Integer, Float> getRefillmentValues() {
        return this.refillment;
    }

    public int getHungerForSlice(int slice) {
        return FoodUtils.getHungerForSlice((int)((Integer)this.refillment.getFirst()), slice);
    }

    public float getSaturationForSlice() {
        return ((Float)this.refillment.getSecond()).floatValue() / 7.0f;
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public void dropItemStack(int slot) {
        Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)this.inventory.getStackInSlot(slot));
    }

    public boolean canAddIngredient(ItemStack stack, int slot) {
        List tags = stack.m_204131_().toList();
        for (TagKey tag : tags) {
            if (!PizzaLayers.VALID_TAGS.contains(tag)) continue;
            if (this.inventory.getStackInSlot(slot).m_41619_()) {
                return true;
            }
            if (this.inventory.getStackInSlot(slot).m_41613_() + 1 > PizzaLayers.getMaxStackSizeForStack(this.inventory.getStackInSlot(slot))) continue;
            return true;
        }
        return false;
    }

    public void decreaseInSlot(int slot, int count) {
        ItemStack stack = this.inventory.getStackInSlot(slot);
        if (stack.m_41613_() >= 2) {
            stack.m_41764_(stack.m_41613_() - count);
        } else {
            this.inventory.setStackInSlot(slot, ItemStack.f_41583_);
        }
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(9){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return PizzaLayers.getMaxStackSizeForStack(stack);
            }

            public int getSlotLimit(int slot) {
                return this.getStackInSlot(slot).m_41619_() ? 1 : PizzaLayers.getMaxStackSizeForStack(this.getStackInSlot(slot));
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (PizzaBlockEntity.this.isRaw() && !PizzaBlockEntity.this.isBaking()) {
                    return PizzaBlockEntity.this.canAddIngredient(stack, slot);
                }
                return false;
            }

            protected void onContentsChanged(int slot) {
                PizzaBlockEntity.this.m_6596_();
                PizzaBlockEntity.this.requestModelDataUpdate();
                PizzaBlockEntity.this.setHungerAndSaturationRefillment();
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new PizzaMenu(id, playerInventory, this);
    }

    public void openGUI(Player player, MenuProvider menuSupplier, BlockPos pos) {
        if (!player.f_19853_.f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)menuSupplier, (BlockPos)pos);
        }
    }

    @Nonnull
    public ModelData getModelData() {
        ModelData.Builder builder = ModelData.builder();
        builder.with(PizzaBakedModel.LAYER_PROVIDERS, Optional.of(this.getInventory()));
        builder.with(PizzaBakedModel.INTEGER_PROPERTY, Optional.of(this.m_58900_().m_60734_() == ModBlocks.PIZZA.get() ? (Integer)this.m_58900_().m_61143_((Property)PizzaBlock.BITES) : Integer.valueOf(0)));
        builder.with(PizzaBakedModel.IS_RAW, Optional.of(this.isRaw()));
        ModelData modelData = builder.build();
        return modelData;
    }

    public ModelData getItemStackModelData(ItemStack stack) {
        this.readFromStack(stack);
        ModelData.Builder builder = ModelData.builder();
        builder.with(PizzaBakedModel.LAYER_PROVIDERS, Optional.of(this.getInventory()));
        builder.with(PizzaBakedModel.INTEGER_PROPERTY, Optional.of(0));
        builder.with(PizzaBakedModel.IS_RAW, Optional.of(stack.m_41720_() == ModItems.RAW_PIZZA.get()));
        return builder.build();
    }
}

